/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.top;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.common.block.entity.IRecipeProcessingBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.SolitaryNestBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TopPlugin
implements Function<ITheOneProbe, Void> {
    MutableComponent formattedName = new TextComponent("Productive Bees").m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC);

    @Override
    @Nullable
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerEntityDisplayOverride((probeMode, probeInfo, player, level, entity, iProbeHitEntityData) -> {
            if (entity instanceof ProductiveBee) {
                ProductiveBee bee = (ProductiveBee)entity;
                if (probeMode.equals((Object)ProbeMode.EXTENDED)) {
                    probeInfo.horizontal().entity(entity).vertical().text(CompoundText.create().name(entity.m_7755_())).text(CompoundText.create().style(TextStyleClass.MODNAME).text("Productive Bees"));
                    ArrayList<Component> list = new ArrayList<Component>();
                    BeeHelper.populateBeeInfoFromEntity(bee, list);
                    for (Component component : list) {
                        probeInfo.mcText(component);
                    }
                    probeInfo.text((Component)this.formattedName);
                    return true;
                }
            }
            return false;
        });
        theOneProbe.registerBlockDisplayOverride((mode, probeInfo, player, world, blockState, data) -> {
            IRecipeProcessingBlockEntity recipeProcessingBlockEntity;
            BlockEntity tileEntity = world.m_7702_(data.getPos());
            if (tileEntity instanceof SolitaryNestBlockEntity) {
                SolitaryNestBlockEntity nest = (SolitaryNestBlockEntity)tileEntity;
                probeInfo.horizontal().item(new ItemStack((ItemLike)blockState.m_60734_().m_5456_())).vertical().itemLabel(new ItemStack((ItemLike)blockState.m_60734_().m_5456_())).text(CompoundText.create().style(TextStyleClass.MODNAME).text("Productive Bees"));
                List<AdvancedBeehiveBlockEntityAbstract.Inhabitant> bees = nest.getBeeList();
                if (!bees.isEmpty()) {
                    probeInfo.text((Component)new TranslatableComponent("productivebees.top.solitary.bee", new Object[]{bees.get((int)0).localizedName}));
                    if (bees.get((int)0).minOccupationTicks - bees.get((int)0).ticksInHive > 0) {
                        probeInfo.progress(Math.max(0, bees.get((int)0).minOccupationTicks - bees.get((int)0).ticksInHive), bees.get((int)0).minOccupationTicks);
                    }
                } else if (nest.getNestTickCooldown() > 0) {
                    probeInfo.text((Component)new TranslatableComponent("productivebees.top.solitary.repopulation_countdown"));
                    probeInfo.progress(nest.getNestTickCooldown() / 20, (Integer)ProductiveBeesConfig.GENERAL.nestSpawnCooldown.get() / 20);
                } else {
                    probeInfo.text((Component)new TranslatableComponent("productivebees.top.solitary.repopulation_countdown_inactive"));
                    if (nest.canRepopulate()) {
                        probeInfo.text((Component)new TranslatableComponent("productivebees.top.solitary.can_repopulate_true"));
                    } else {
                        probeInfo.text((Component)new TranslatableComponent("productivebees.top.solitary.can_repopulate_false"));
                    }
                }
                return true;
            }
            if (tileEntity instanceof IRecipeProcessingBlockEntity && (recipeProcessingBlockEntity = (IRecipeProcessingBlockEntity)tileEntity).getRecipeProgress() > 0) {
                probeInfo.horizontal().item(new ItemStack((ItemLike)blockState.m_60734_().m_5456_())).vertical().itemLabel(new ItemStack((ItemLike)blockState.m_60734_().m_5456_())).progress(recipeProcessingBlockEntity.getRecipeProgress() / 20, recipeProcessingBlockEntity.getProcessingTime() / 20).text(CompoundText.create().style(TextStyleClass.MODNAME).text("Productive Bees"));
                return true;
            }
            return false;
        });
        return null;
    }
}

